﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;
using Azyobuzi.りすにんぐついったー;
using System.Net;
using System.Xml;
using System.IO;
using System.Text.RegularExpressions;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class MainForm : Form
    {
        bool over = false;
        string oldData = "";
        public bool BalloonTipVisible = false;

        public MainForm()
        {
            InitializeComponent();

            this.Icon = Resources.mainIco;
            notifyIcon1.Icon = Resources.mainIco;
        }

        uint interval;
        IMusicDataListener musicDataListener = new WmpListener();

        private void OneSecTimer_Tick(object sender, EventArgs e)
        {
            interval -= 1;
            var m = interval / 60;
            var s = interval % 60;
            timeLbl.Text = string.Format("{0}分{1}秒後に投稿されます", m, s);

            if (interval == 0)
            {
                PostTweet(true);
                interval = SettingsXml.Instance.interval;
            }
        }

        public void PostTweet(bool auto)
        {
            var tweet = tweetBox.Text.Trim();

            if (!(this.Visible && tweetBox.Focused) && tweet != oldData && !string.IsNullOrWhiteSpace(tweet))
            {
                OneSecTimer.Stop();
                postBtn.Enabled = false;
                今すぐ投稿NToolStripMenuItem.Enabled = false;
                waitPicBox.Visible = true;
                timeLbl.Text = "Sending...";
                waitPicBox.Refresh();
                timeLbl.Refresh();

                postBgWorker.RunWorkerAsync(new Tuple<string, bool>(tweet, auto));
            }
        }

        private void postBgWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            var args = (Tuple<string, bool>)e.Argument;
            var li = new LogItem()
            {
                Tweet = args.Item1,
                Auto = args.Item2
            };

            var content = "";
            string statusId;
            HttpStatusCode hsc = Program.twitterConnection.UpdateStatus(args.Item1, ref content);
            if (hsc == HttpStatusCode.OK && tryGetStatusIdFromXml(content, out statusId))
            {
                li.TweetID = statusId;
                this.Invoke((Action)delegate { notifyIcon1.ShowBalloonTip(0, "投稿しました", args.Item1, ToolTipIcon.Info); });
                li.Success = true;
                li.DeleteBtn = true;
            }
            else
            {
                string errmsg = tryGetErrorMessage(content);
                string msg;
                if (errmsg == null) msg = hsc.ToString(); else msg = errmsg;
                this.Invoke((Action)delegate { notifyIcon1.ShowBalloonTip(0, "投稿に失敗しました", msg, ToolTipIcon.Error); });
            }

            li.Date = DateTime.Now;

            e.Result = li;
        }

        private void postBgWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            var li = (LogItem)e.Result;
            LogSettingsManager.AddLog(li);
            if (li.Success)
            {
                oldData = li.Tweet;
                postBtn.Enabled = false;
                今すぐ投稿NToolStripMenuItem.Enabled = false;
            }
            else
            {
                postBtn.Enabled = true;
                今すぐ投稿NToolStripMenuItem.Enabled = true;
            }

            timeLbl.Text = "";
            waitPicBox.Visible = false;

            interval = SettingsXml.Instance.interval;
            if (SettingsXml.Instance.auto) { OneSecTimer.Start(); }
        }

        private bool tryGetStatusIdFromXml(string xml, out string statusId)
        {
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.LoadXml(xml);
            }
            catch (XmlException)
            {
                statusId = "";
                return false;
            }
            XmlNode node = xmlDoc.SelectSingleNode("/status/id");
            if (node == null)
            {
                statusId = "";
                return false;
            }
            else
            {
                statusId = node.InnerText;
                return true;
            }
        }

        private string tryGetErrorMessage(string xml)//エラー時はnullを返す
        {
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.LoadXml(xml);
            }
            catch (XmlException)
            {
                return null;
            }
            XmlNode node = xmlDoc.SelectSingleNode("/hash/error");
            if (node == null)
            {
                return null;
            }
            else
            {
                return node.InnerText;
            }
        }

        internal Version GetVersion()
        {
            System.Reflection.Assembly asm = System.Reflection.Assembly.GetExecutingAssembly();
            return asm.GetName().Version;
        }

        private void MainForm_Shown(object sender, EventArgs e)
        {
            this.Visible = false;

            //バージョンチェック
            Version netver = null;
            using (var wc = new WebClient()) 
            {
                try 
                {
                    netver = new Version(wc.DownloadString("http://listwi.sourceforge.jp/version.txt"));
                } catch (WebException) { }
            }
            if (netver != null && netver > GetVersion() && MessageBox.Show("最新版 "+ netver.ToString() + 
                " がリリースされています。ダウンロードしますか？","りすにんぐついったー",
                MessageBoxButtons.YesNo,MessageBoxIcon.Information) == DialogResult.Yes)
            {
                System.Diagnostics.Process.Start("http://sourceforge.jp/projects/listwi/releases/");
                if (MessageBox.Show("りすにんぐついったーを終了しますか？", "終了確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
                {
                    Application.Exit();
                }
            }

            //初期化
            var s = SettingsXml.Instance;
            if (string.IsNullOrEmpty(s.accessToken) || string.IsNullOrEmpty(s.accessTokenSecret))
            {
                auth();
            }
            else
            {
                Program.twitterConnection.Initialize("GmeOXd6M3zE89zKqsJwjw", "Wq9lBb5VpW4To5QLi4lFc5sb2ne5tiCxyS6iHmWFG6s", s.accessToken, s.accessTokenSecret, "");
            }

            notifyIcon1.Visible = true;

            

            var myname = Program.twitterConnection.GetMyScreenName();
            if (myname == null)
            {
                notifyIcon1.Visible = false;
                auth();
                notifyIcon1.Visible = true;
                myname = Program.twitterConnection.GetMyScreenName();
            }

            notifyIcon1.ShowBalloonTip(0, "", "@" + myname + " さん、ようこそ", ToolTipIcon.None);

            //投稿内容が旧書式でないか確認
            if (Regex.IsMatch(s.template, @"\%\d")) MessageBox.Show("投稿内容が古いバージョンの書式です。変更してください。", "互換性の問題", MessageBoxButtons.OK, MessageBoxIcon.Warning);

            musicDataListener.ListeningMusicChanged += this.musicDataListener_ListeningMusicChanged;
            if (s.get_mode == GetMode.LiveMessenger)
            {
                liveMessengerモードLToolStripMenuItem.Checked = true;
            }
            else
            {
                iTunesモードTToolStripMenuItem.Checked = true;
            }
            
            interval = s.interval;
            if (s.auto) { OneSecTimer.Start(); }
        }

        private void auth()
        {
            MessageBox.Show("Twitter認証を行います。", "Twitter認証", MessageBoxButtons.OK, MessageBoxIcon.Information);
            var f = new AuthForm();
            if (f.ShowDialog(this) == DialogResult.Cancel)
            {
                Application.Exit();
            }
        }

        private void 終了XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {
                try { musicDataListener.Stop(); musicDataListener.Dispose(); }
                catch { /*何もしない*/ }

                //設定保存
                SettingsXml.Instance.bouds = this.Bounds;
                SettingsXml.Save();
                LogSettingsManager.Save();
            }
        }

        private void tweetBox_Enter(object sender, EventArgs e)
        {
            if (!over)
            {
                tweetBox.BackColor = SystemColors.Info;
            }
        }

        private void tweetBox_Leave(object sender, EventArgs e)
        {
            if (!over)
            {
                tweetBox.BackColor = SystemColors.Window;
            }
        }

        private void tweetBox_TextChanged(object sender, EventArgs e)
        {
            int length = tweetBox.Text.Trim().Length;

            charcount.Text = "残り" + (140 - length) + "文字";

            if (length > 140)
            {
                over = true;
            }
            else
            {
                over = false;
            }
            TweetBoxBackColor();

            postBtn.Enabled = length != 0 && tweetBox.Text.Trim() != oldData;
        }

        public void TweetBoxBackColor()
        {
            if (over)
            {
                tweetBox.BackColor = Color.Red;
            }
            else if (tweetBox.Focused)
            {
                tweetBox_Enter(tweetBox, new EventArgs());
            }
            else
            {
                tweetBox_Leave(tweetBox, new EventArgs());
            }
        }

        private void 設定SToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SettingsForm.ShowForm();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            var s = SettingsXml.Instance;
            this.Bounds = s.bouds;
            自動投稿PToolStripMenuItem.Checked = s.auto;
        }

        private void postBtn_Click(object sender, EventArgs e)
        {
            PostTweet(false);
        }

        private void 自動投稿PToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            var c = 自動投稿PToolStripMenuItem.Checked;
            SettingsXml.Instance.auto = c;

            if (c)
            {
                OneSecTimer.Start();
            }
            else
            {
                OneSecTimer.Stop();
                timeLbl.Text = "";
                interval = SettingsXml.Instance.interval;
            }
        }

        private void メイン画面を表示VToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Visible = true;
        }

        private void MainForm_Deactivate(object sender, EventArgs e)
        {
            tweetBox_Leave(tweetBox, new EventArgs());
        }

        private void MainForm_Activated(object sender, EventArgs e)
        {
            TweetBoxBackColor();
        }

        private void つぶやきログLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LogForm.ShowForm();
        }

        private void listeningMessenderMToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ListeningMessender.ShowForm();
        }

        private void wikiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Program.ShowWiki("FrontPage");
        }

        private void バージョン情報AToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show(string.Format("りすにんぐついったー\n\nVersion {0}", GetVersion()), "りすにんぐついったー", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                this.Visible = true;
                this.Activate();
            }
        }

        private void liveMessengerモードLToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            if (liveMessengerモードLToolStripMenuItem.Checked)
            {
                iTunesモードTToolStripMenuItem.Checked = false;
                musicDataListener.Dispose();
                musicDataListener = new WmpListener();
                musicDataListener.Start();
                musicDataListener.ListeningMusicChanged += this.musicDataListener_ListeningMusicChanged;
                SettingsXml.Instance.get_mode = GetMode.LiveMessenger;
            }
        }

        private void iTunesモードTToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            if (iTunesモードTToolStripMenuItem.Checked)
            {
                iTunesListener itl = null;
                try {
                    itl = new iTunesListener();
                } catch (System.Runtime.InteropServices.COMException) {
                    MessageBox.Show("iTunesが見付かりませんでした。", "iTunesモード",MessageBoxButtons.OK,MessageBoxIcon.Warning);
                    iTunesモードTToolStripMenuItem.Checked = false;
                    return;
                }

                liveMessengerモードLToolStripMenuItem.Checked = false;
                musicDataListener.Dispose();
                musicDataListener = itl;
                musicDataListener.Start();
                musicDataListener.ListeningMusicChanged += this.musicDataListener_ListeningMusicChanged;
                SettingsXml.Instance.get_mode = GetMode.iTunes;
            }
        }

        ListeningMusicChangedEventArgs oldEventArgs;
        private void musicDataListener_ListeningMusicChanged(object sender, ListeningMusicChangedEventArgs e)
        {
            this.Invoke((MethodInvoker)delegate
            {
                if (string.IsNullOrWhiteSpace(e.Title) && string.IsNullOrWhiteSpace(e.Artist) && string.IsNullOrWhiteSpace(e.Album))
                {
                    tweetBox.Text = "";
                }
                else
                {
                    oldEventArgs = e;

                    string re;
                    re = string.Format(SettingsXml.Instance.template, e.Title, e.Artist, e.Album);

                    tweetBox.Text = re;
                }
            });
        }

        private void notifyIcon1_BalloonTipShown(object sender, EventArgs e)
        {
            BalloonTipVisible = true;
        }

        private void notifyIcon1_BalloonTipClosed(object sender, EventArgs e)
        {
            BalloonTipVisible = false;
        }

        private void モードToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ((ToolStripMenuItem)sender).Checked = true;
        }

        private void 再取得RToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (oldEventArgs == null) return;
            musicDataListener_ListeningMusicChanged(musicDataListener, oldEventArgs);
        }
    }
}
